/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class DefaultAggregatorCollectionTest
extends ContextTestSupport {
    @Test
    public void testDefaultAggregateCollection() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(4);
        result.expectedBodiesReceivedInAnyOrder(new Object[]{"Message 1d", "Message 2b", "Message 3c", "Message 4"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 1a", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 2a", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 3a", "id", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 1b", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 3b", "id", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 1c", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 3c", "id", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 2b", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 1d", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"Message 4", "id", (Object)"4");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id")).aggregationStrategy((AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(500L).to("mock:result");
            }
        };
    }
}

