/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AbstractListAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomListAggregationStrategyTest
extends ContextTestSupport {
    @Test
    public void testCustomAggregationStrategy() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"100", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"150", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"130", "id", (Object)"1");
        this.assertMockEndpointsSatisfied();
        List numbers = (List)((Exchange)result.getExchanges().get(0)).getIn().getBody(List.class);
        Assertions.assertNotNull((Object)numbers);
        Assertions.assertEquals((Object)Integer.valueOf("100"), numbers.get(0));
        Assertions.assertEquals((Object)Integer.valueOf("150"), numbers.get(1));
        Assertions.assertEquals((Object)Integer.valueOf("130"), numbers.get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((AggregateDefinition)this.from("direct:start").aggregate((AggregationStrategy)new MyListOfNumbersStrategy()).header("id")).completionSize(3).to("mock:result");
            }
        };
    }

    public static final class MyListOfNumbersStrategy
    extends AbstractListAggregationStrategy<Integer> {
        public Integer getValue(Exchange exchange) {
            return (Integer)exchange.getIn().getBody(Integer.class);
        }
    }
}

