/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.aggregate.AbstractListAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomListAggregationStrategySplitTest
extends ContextTestSupport {
    @Test
    public void testCustomAggregationStrategy() throws Exception {
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{100, 150, 130});
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        ((MockValueBuilder)result.message(0).body()).isInstanceOf(List.class);
        ArrayList<String> body = new ArrayList<String>();
        body.add("100");
        body.add("150");
        body.add("130");
        this.template.sendBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
        List numbers = (List)((Exchange)result.getExchanges().get(0)).getIn().getBody(List.class);
        Assertions.assertNotNull((Object)numbers);
        Assertions.assertEquals((Object)Integer.valueOf("100"), numbers.get(0));
        Assertions.assertEquals((Object)Integer.valueOf("150"), numbers.get(1));
        Assertions.assertEquals((Object)Integer.valueOf("130"), numbers.get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body(), (AggregationStrategy)new MyListOfNumbersStrategy()).to("mock:line")).end().to("mock:result");
            }
        };
    }

    public static final class MyListOfNumbersStrategy
    extends AbstractListAggregationStrategy<Integer> {
        public Integer getValue(Exchange exchange) {
            String s = (String)exchange.getIn().getBody(String.class);
            return Integer.valueOf(s);
        }
    }
}

