/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AbstractListAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomListAggregationStrategyCompletionFromBatchConsumerTest
extends ContextTestSupport {
    @Test
    public void testCustomAggregationStrategy() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"100", "CamelFileName", (Object)"1.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"150", "CamelFileName", (Object)"2.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"130", "CamelFileName", (Object)"3.txt");
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        List numbers = (List)((Exchange)result.getExchanges().get(0)).getIn().getBody(List.class);
        Assertions.assertNotNull((Object)numbers);
        Assertions.assertEquals((Object)Integer.valueOf("100"), numbers.get(0));
        Assertions.assertEquals((Object)Integer.valueOf("150"), numbers.get(1));
        Assertions.assertEquals((Object)Integer.valueOf("130"), numbers.get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((AggregateDefinition)this.from(CustomListAggregationStrategyCompletionFromBatchConsumerTest.this.fileUri("?initialDelay=0&delay=10&sortBy=file:name")).routeId("foo").autoStartup(false).aggregate((AggregationStrategy)new MyListOfNumbersStrategy()).constant((Object)true)).completionFromBatchConsumer().to("mock:result");
            }
        };
    }

    public static final class MyListOfNumbersStrategy
    extends AbstractListAggregationStrategy<Integer> {
        public Integer getValue(Exchange exchange) {
            String s = (String)exchange.getIn().getBody(String.class);
            return Integer.valueOf(s);
        }
    }
}

