/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomAggregationStrategyServiceTest
extends ContextTestSupport {
    private final MyCustomStrategy strategy = new MyCustomStrategy();

    @Test
    public void testCustomAggregationStrategy() throws Exception {
        Assertions.assertTrue((boolean)this.strategy.start, (String)"Should be started");
        Assertions.assertFalse((boolean)this.strategy.stop, (String)"Should not be stopped");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"100", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"150", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"130", "id", (Object)"1");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertFalse((boolean)this.strategy.start, (String)"Should not be started");
        Assertions.assertTrue((boolean)this.strategy.stop, (String)"Should be stopped");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((AggregateDefinition)this.from("direct:start").aggregate((AggregationStrategy)CustomAggregationStrategyServiceTest.this.strategy).header("id")).completionSize(3).to("mock:result");
            }
        };
    }

    public static final class MyCustomStrategy
    extends ServiceSupport
    implements AggregationStrategy {
        public boolean stop;
        public boolean start;

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            return newExchange;
        }

        protected void doStart() {
            this.start = true;
            this.stop = false;
        }

        protected void doStop() {
            this.stop = true;
            this.start = false;
        }
    }
}

