/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.junit.jupiter.api.Test;

public class BodyOnlyAggregationStrategyTest
extends ContextTestSupport {
    @Test
    public void exceptionRouteTest() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:failingRoute").expectedMessageCount(1);
        this.getMockEndpoint("mock:nextRoute").expectedMessageCount(0);
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DefaultErrorHandlerDefinition dh = this.deadLetterChannel("direct:error").useOriginalMessage();
                ((RouteDefinition)this.from("direct:failingRoute").errorHandler((ErrorHandlerFactory)dh).to("mock:failingRoute")).throwException((Exception)new RuntimeException("Boem!"));
                this.from("direct:error").to("mock:error");
                this.from("direct:nextRoute").to("mock:nextRoute");
                ((RouteDefinition)this.from("direct:start").enrich("direct:failingRoute", (AggregationStrategy)new BodyOnlyAggregationStrategy())).to("direct:nextRoute");
            }
        };
    }

    public static class BodyOnlyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            oldExchange.getIn().setBody(newExchange.getIn().getBody());
            oldExchange.getExchangeExtension().setErrorHandlerHandled(newExchange.getExchangeExtension().getErrorHandlerHandled());
            return oldExchange;
        }
    }
}

