/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
public class AlbertoAggregatorTest
extends ContextTestSupport {
    private static final String SURNAME_HEADER = "surname";
    private static final String TYPE_HEADER = "type";
    private static final String BROTHERS_TYPE = "brothers";

    @Test
    public void testAggregator() throws Exception {
        String allNames = "Harpo Marx,Fiodor Karamazov,Chico Marx,Ivan Karamazov,Groucho Marx,Alexei Karamazov,Dimitri Karamazov";
        Map<String, List<String>> allBrothers = AlbertoAggregatorTest.getAllBrothers();
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedBodiesReceived(new Object[]{allBrothers});
        this.template.sendBody("direct:start", (Object)allNames);
        this.assertMockEndpointsSatisfied();
    }

    private static Map<String, List<String>> getAllBrothers() {
        ArrayList<String> marxBrothers = new ArrayList<String>();
        marxBrothers.add("Harpo");
        marxBrothers.add("Chico");
        marxBrothers.add("Groucho");
        ArrayList<String> karamazovBrothers = new ArrayList<String>();
        karamazovBrothers.add("Fiodor");
        karamazovBrothers.add("Ivan");
        karamazovBrothers.add("Alexei");
        karamazovBrothers.add("Dimitri");
        HashMap<String, List<String>> allBrothers = new HashMap<String, List<String>>();
        allBrothers.put("Marx", marxBrothers);
        allBrothers.put("Karamazov", karamazovBrothers);
        return allBrothers;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){
            final AggregationStrategy surnameAggregator = new AggregationStrategy(){

                public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                    this.debugIn("Surname Aggregator", oldExchange, newExchange);
                    Exchange answer = newExchange;
                    if (oldExchange != null) {
                        List brothers = (List)oldExchange.getIn().getBody(List.class);
                        brothers.add((String)newExchange.getIn().getBody(String.class));
                        answer = oldExchange;
                    } else {
                        ArrayList<String> brothers = new ArrayList<String>();
                        brothers.add((String)newExchange.getIn().getBody(String.class));
                        newExchange.getIn().setBody(brothers);
                    }
                    this.debugOut("Surname Aggregator", answer);
                    return answer;
                }
            };
            final AggregationStrategy brothersAggregator = new AggregationStrategy(){

                public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                    this.debugIn("Brothers Aggregator", oldExchange, newExchange);
                    Exchange answer = newExchange;
                    if (oldExchange != null) {
                        Map brothers = (Map)oldExchange.getIn().getBody(Map.class);
                        brothers.put((String)newExchange.getIn().getHeader(AlbertoAggregatorTest.SURNAME_HEADER, String.class), (List)newExchange.getIn().getBody(List.class));
                        answer = oldExchange;
                    } else {
                        HashMap<String, List> brothers = new HashMap<String, List>();
                        brothers.put((String)newExchange.getIn().getHeader(AlbertoAggregatorTest.SURNAME_HEADER, String.class), (List)newExchange.getIn().getBody(List.class));
                        newExchange.getIn().setBody(brothers);
                    }
                    this.debugOut("Brothers Aggregator", answer);
                    return answer;
                }
            };

            private void debugIn(String stringId, Exchange oldExchange, Exchange newExchange) {
                if (oldExchange != null) {
                    this.log.debug("{} old headers in: {}", (Object)stringId, (Object)oldExchange.getIn().getHeaders());
                    this.log.debug("{} old body in: {}", (Object)stringId, oldExchange.getIn().getBody());
                }
                this.log.debug("{} new headers in: {}", (Object)stringId, (Object)newExchange.getIn().getHeaders());
                this.log.debug("{} new body in: {}", (Object)stringId, newExchange.getIn().getBody());
            }

            private void debugOut(String stringId, Exchange exchange) {
                this.log.debug("{} old headers out: {}", (Object)stringId, (Object)exchange.getIn().getHeaders());
                this.log.debug("{} old body out: {}", (Object)stringId, exchange.getIn().getBody());
            }

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.bodyAs(String.class).tokenize(",")).process(new Processor(){

                    public void process(Exchange exchange) {
                        String[] parts = ((String)exchange.getIn().getBody(String.class)).split(" ");
                        exchange.getIn().setBody((Object)parts[0]);
                        exchange.getIn().setHeader(AlbertoAggregatorTest.SURNAME_HEADER, (Object)parts[1]);
                    }
                })).to("direct:joinSurnames");
                ((AggregateDefinition)this.from("direct:joinSurnames").aggregate((Expression)this.header(AlbertoAggregatorTest.SURNAME_HEADER), this.surnameAggregator).completionTimeout(100L).completionTimeoutCheckerInterval(10L).setHeader(AlbertoAggregatorTest.TYPE_HEADER, (Expression)this.constant(AlbertoAggregatorTest.BROTHERS_TYPE))).to("direct:joinBrothers");
                AggregateDefinition agg = this.from("direct:joinBrothers").aggregate((Expression)this.header(AlbertoAggregatorTest.TYPE_HEADER), this.brothersAggregator);
                agg.completionTimeout(100L);
                agg.completionTimeoutCheckerInterval(10L);
                ((AggregateDefinition)((AggregateDefinition)agg.removeHeader(AlbertoAggregatorTest.SURNAME_HEADER)).removeHeader(AlbertoAggregatorTest.TYPE_HEADER)).to("mock:result");
            }
        };
    }
}

