/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.HashMap;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class AggregatorTest
extends ContextTestSupport {
    protected final int messageCount = 100;

    @Test
    public void testSendingLotsOfMessagesGetAggregatedToTheLatestMessage() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{"message:100"});
        for (int i = 1; i <= 100; ++i) {
            String body = "message:" + i;
            this.template.sendBodyAndHeader("direct:many", (Object)body, "cheese", (Object)123);
        }
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testOneMessage() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("cheese", 123);
        headers.put("bar", "viper bar");
        this.template.sendBodyAndHeaders("direct:predicate", (Object)"test", headers);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testBatchTimeoutExpiry() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"message:1", "cheese", (Object)123);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testAggregatorNotAtStart() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        ((MockValueBuilder)resultEndpoint.message(0).header("visited")).isNotNull();
        this.template.sendBodyAndHeader("seda:header", (Object)"message:1", "cheese", (Object)123);
        resultEndpoint.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:many").aggregate((Expression)this.header("cheese"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(2000L).completionTimeoutCheckerInterval(100L).to("mock:result");
                this.from("direct:start").aggregate((Expression)this.header("cheese"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(100L).completionTimeoutCheckerInterval(10L).to("mock:result");
                ((RouteDefinition)this.from("seda:header").setHeader("visited", (Expression)this.constant(true))).aggregate((Expression)this.header("cheese"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(100L).completionTimeoutCheckerInterval(10L).to("mock:result");
                this.from("direct:predicate").aggregate((Expression)this.header("cheese"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(100L).completionTimeoutCheckerInterval(10L).completionPredicate(this.header("cheese").isEqualTo((Object)123)).to("mock:result");
            }
        };
    }
}

