/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class AggregatorLockingTest
extends ContextTestSupport {
    private final CountDownLatch latch = new CountDownLatch(2);

    @Test
    public void testAggregationWithoutParallelNorOptimisticShouldNotLockDownstreamProcessors() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"a", "b"});
        this.template.sendBodyAndHeader("seda:a", (Object)"a", "myId", (Object)1);
        this.template.sendBodyAndHeader("seda:a", (Object)"b", "myId", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(1L));
                ((AggregateDefinition)((AggregateDefinition)((AggregateDefinition)this.from("seda:a?concurrentConsumers=2").aggregate((Expression)this.header("myId"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionSize(1).log("Before await with thread: ${threadName} and body: ${body}")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        AggregatorLockingTest.this.latch.countDown();
                        if (!AggregatorLockingTest.this.latch.await(1L, TimeUnit.SECONDS)) {
                            throw new RuntimeException("Took too long; assume threads are blocked and fail test");
                        }
                    }
                })).log("After await with thread: ${threadName} and body: ${body}")).to("mock:result");
            }
        };
    }
}

