/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class AggregatorExceptionTest
extends ContextTestSupport {
    @Test
    public void testAggregateAndOnException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMessageCount(2);
        for (int c = 0; c <= 10; ++c) {
            this.template.sendBodyAndHeader("direct:start", (Object)("Hi!" + c), "id", (Object)123);
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                String exceptionString = "This is an Error not an Exception";
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionSize(5).process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new NoSuchMethodError("This is an Error not an Exception");
                    }
                });
            }
        };
    }
}

