/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class AggregatorExceptionInPredicateTest
extends ContextTestSupport {
    @Test
    public void testExceptionInAggregationStrategy() throws Exception {
        this.testExceptionInFlow("direct:start");
    }

    @Test
    public void testExceptionInPredicate() throws Exception {
        this.testExceptionInFlow("direct:predicate");
    }

    private void testExceptionInFlow(String startUri) throws Exception {
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(startUri, (Object)"Damn", "id", (Object)1);
        this.template.sendBodyAndHeader(startUri, (Object)"Hello World", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:handled");
                this.from("direct:start").aggregate((Expression)this.header("id")).completionTimeout(500L).aggregationStrategy(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        Object body = newExchange.getIn().getBody();
                        if ("Damn".equals(body)) {
                            throw new IllegalArgumentException();
                        }
                        return newExchange;
                    }
                }).to("mock:result");
                this.from("direct:predicate").aggregate(new Expression(){

                    public <T> T evaluate(Exchange exchange, Class<T> type) {
                        if (exchange.getIn().getBody().equals("Damn")) {
                            throw new IllegalArgumentException();
                        }
                        return (T)ExpressionBuilder.headerExpression((String)"id").evaluate(exchange, type);
                    }
                }, (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(500L).to("mock:result");
            }
        };
    }
}

