/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class AggregatorExceptionHandleTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHandled() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:handled");
        mock.expectedBodiesReceived(new Object[]{"Damn"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Damn", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:handled");
                ((AggregateDefinition)this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(100L).completionTimeoutCheckerInterval(10L).process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Damn".equals(body)) {
                            throw new IllegalArgumentException("Damn");
                        }
                        exchange.getMessage().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
            }
        };
    }
}

