/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Isolated(value="Creates lots of threads")
public class AggregatorConcurrencyTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatorConcurrencyTest.class);
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final AtomicInteger SUM = new AtomicInteger();
    private final String uri = "direct:start";

    @Test
    public void testAggregateConcurrency() throws Exception {
        int total = 0;
        ExecutorService service = Executors.newFixedThreadPool(20);
        ArrayList<1> tasks = new ArrayList<1>();
        int size = 100;
        for (int i = 0; i < size; ++i) {
            final int count = i;
            total += i;
            tasks.add(new Callable<Object>(){

                @Override
                public Object call() {
                    AggregatorConcurrencyTest.this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "index", (Object)count);
                    return null;
                }
            });
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{total});
        mock.expectedHeaderReceived("total", (Object)total);
        mock.expectedPropertyReceived("CamelAggregatedSize", (Object)size);
        service.invokeAll(tasks);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)100, (int)COUNTER.get());
        service.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.constant(true), new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        Exchange answer = oldExchange != null ? oldExchange : newExchange;
                        COUNTER.getAndIncrement();
                        Integer newIndex = (Integer)newExchange.getIn().getHeader("index", Integer.class);
                        int total = SUM.addAndGet(newIndex);
                        answer.getIn().setHeader("total", (Object)total);
                        LOG.debug("Index: {}. Total so far: {}", (Object)newIndex, (Object)total);
                        return answer;
                    }
                }).completionTimeout(60000L).completionPredicate(this.exchangeProperty("CamelAggregatedSize").isEqualTo((Object)100)).to("direct:foo");
                ((ProcessorDefinition)this.from("direct:foo").setBody().header("total")).to("mock:result");
            }
        };
    }
}

