/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregationStrategyLifecycleTest
extends ContextTestSupport {
    private final MyCompletionStrategy strategy = new MyCompletionStrategy();

    @Test
    public void testAggregateLifecycle() throws Exception {
        Assertions.assertTrue((boolean)this.strategy.isStarted(), (String)"Should be started");
        Assertions.assertSame((Object)this.context, (Object)this.strategy.getCamelContext());
        MockEndpoint result = this.getMockEndpoint("mock:aggregated");
        result.expectedBodiesReceived(new Object[]{"A+B+C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertTrue((boolean)this.strategy.isStopped(), (String)"Should be stopped");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)AggregationStrategyLifecycleTest.this.strategy).completionSize(3).to("mock:aggregated");
            }
        };
    }

    private static final class MyCompletionStrategy
    extends ServiceSupport
    implements AggregationStrategy,
    CamelContextAware {
        private CamelContext camelContext;
        private String separator;

        private MyCompletionStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class) + this.separator + (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)body);
            return oldExchange;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        protected void doStart() {
            ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
            this.separator = "+";
        }
    }
}

