/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregationStrategyGroupedBodyTest
extends ContextTestSupport {
    @Test
    public void testAggregate() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"C");
        this.assertMockEndpointsSatisfied();
        List list = (List)((Exchange)this.getMockEndpoint("mock:result").getExchanges().get(0)).getMessage().getBody();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((Object)"A", list.get(0));
        Assertions.assertEquals((Object)"B", list.get(1));
        Assertions.assertEquals((Object)"C", list.get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.constant(true), AggregationStrategies.groupedBody()).completionSize(3).to("mock:result");
            }
        };
    }
}

