/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class AggregationStrategyBeanAdapterWithHeadersTest
extends ContextTestSupport {
    private final MyBodyAppender appender = new MyBodyAppender();

    @Test
    public void testAggregate() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"ABC"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("count", (Object)6);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "count", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "count", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "count", (Object)3);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.constant(true), AggregationStrategies.bean((Object)AggregationStrategyBeanAdapterWithHeadersTest.this.appender, (String)"appendWithHeaders")).completionSize(3).to("mock:result");
            }
        };
    }

    public static final class MyBodyAppender {
        public String appendWithHeaders(String existing, Map<String, Integer> oldHeaders, String next, Map<String, Integer> newHeaders) {
            if (next != null) {
                Integer count = oldHeaders.get("count") + newHeaders.get("count");
                oldHeaders.put("count", count);
                return existing + next;
            }
            return existing;
        }
    }
}

