/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AggregationStrategyBeanAdapterWithHeadersAndPropertiesTest
extends ContextTestSupport {
    private final MyBodyAppender appender = new MyBodyAppender();

    @Test
    public void testAggregate() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"ABC"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"yesyesyes");
        this.getMockEndpoint("mock:result").expectedPropertyReceived("count", (Object)6);
        this.template.sendBodyAndProperty("direct:start", (Object)"A", "count", (Object)1);
        this.template.sendBodyAndProperty("direct:start", (Object)"B", "count", (Object)2);
        this.template.sendBodyAndProperty("direct:start", (Object)"C", "count", (Object)3);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setHeader("foo", (Expression)this.constant("yes"))).aggregate((Expression)this.constant(true), AggregationStrategies.bean((Object)AggregationStrategyBeanAdapterWithHeadersAndPropertiesTest.this.appender, (String)"appendWithHeadersAndProperties")).completionSize(3).to("mock:result");
            }
        };
    }

    public static final class MyBodyAppender {
        public String appendWithHeadersAndProperties(String existing, Map<String, String> oldHeaders, Map<String, Integer> oldProperties, String next, Map<String, String> newHeaders, Map<String, Integer> newProperties) {
            if (next != null) {
                Integer count = oldProperties.get("count") + newProperties.get("count");
                oldProperties.put("count", count);
                String foo = oldHeaders.get("foo") + newHeaders.get("foo");
                oldHeaders.put("foo", foo);
                return existing + next;
            }
            return existing;
        }
    }
}

