/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.aggregator.AggregationStrategyBeanAdapterTest;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class AggregationStrategyBeanAdapterRefTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myAppender", (Object)new AggregationStrategyBeanAdapterTest.MyBodyAppender());
        return jndi;
    }

    @Test
    public void testAggregate() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"ABC"});
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"C");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.constant(true)).aggregationStrategy("myAppender").completionSize(3).to("mock:result");
            }
        };
    }

    public static final class MyBodyAppender {
        public String append(String existing, String next) {
            if (next != null) {
                return existing + next;
            }
            return existing;
        }
    }
}

