/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AggregationStrategyBeanAdapterPollEnrichTest
extends ContextTestSupport {
    private final MyBodyAppender appender = new MyBodyAppender();

    @Test
    public void testNoData() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("direct:start", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testData() throws Exception {
        this.template.sendBody("seda:foo", (Object)"B");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AB"});
        this.template.sendBody("direct:start", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").pollEnrich("seda:foo", 100L, AggregationStrategies.bean((Object)AggregationStrategyBeanAdapterPollEnrichTest.this.appender))).to("mock:result");
            }
        };
    }

    public static final class MyBodyAppender {
        public String append(String existing, String next) {
            return existing + next;
        }
    }
}

