/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregationStrategyBeanAdapterAllowNullTest
extends ContextTestSupport {
    private final MyUserAppender appender = new MyUserAppender();

    @Test
    public void testAggregate() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)new User("Claus"));
        this.template.sendBody("direct:start", (Object)new User("James"));
        this.template.sendBody("direct:start", (Object)new User("Jonathan"));
        this.assertMockEndpointsSatisfied();
        List names = (List)((Exchange)this.getMockEndpoint("mock:result").getReceivedExchanges().get(0)).getIn().getBody(List.class);
        Assertions.assertEquals((Object)"Claus", names.get(0));
        Assertions.assertEquals((Object)"James", names.get(1));
        Assertions.assertEquals((Object)"Jonathan", names.get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.constant(true), AggregationStrategies.beanAllowNull((Object)AggregationStrategyBeanAdapterAllowNullTest.this.appender, (String)"addUsers")).completionSize(3).to("mock:result");
            }
        };
    }

    public static final class MyUserAppender {
        public List<String> addUsers(List<String> names, User user) {
            if (names == null) {
                names = new ArrayList<String>();
            }
            names.add(user.getName());
            return names;
        }
    }

    @XmlRootElement(name="user")
    public static final class User {
        private final String name;

        public User(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

