/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.junit.jupiter.api.Test;

public class AggregationStrategyBeanAdapterAllowNullOldExchangeTest
extends ContextTestSupport {
    private final MyBodyAppender appender = new MyBodyAppender();
    private AggregationStrategyBeanAdapter myStrategy;

    @Test
    public void testAggregate() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"OldWasNullABC"});
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"C");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AggregationStrategyBeanAdapterAllowNullOldExchangeTest.this.myStrategy = new AggregationStrategyBeanAdapter((Object)AggregationStrategyBeanAdapterAllowNullOldExchangeTest.this.appender, "append");
                AggregationStrategyBeanAdapterAllowNullOldExchangeTest.this.myStrategy.setAllowNullOldExchange(true);
                this.from("direct:start").aggregate((Expression)this.constant(true), (AggregationStrategy)AggregationStrategyBeanAdapterAllowNullOldExchangeTest.this.myStrategy).completionSize(3).to("mock:result");
            }
        };
    }

    public static final class MyBodyAppender {
        public String append(String existing, String next) {
            if (existing == null) {
                return "OldWasNull" + next;
            }
            if (next != null) {
                return existing + next;
            }
            return existing;
        }
    }
}

