/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.processor.aggregator.AggregateTimeoutWithExecutorServiceTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="camel.threads.virtual.enabled", matches="true", disabledReason="In case of Virtual Threads, the threads cannot be counted this way")
public class AggregateTimeoutWithNoExecutorServiceTest
extends ContextTestSupport {
    @Test
    public void testThreadUsedForEveryAggregatorWhenDefaultExecutorServiceUsed() throws Exception {
        int i;
        Assertions.assertTrue((AggregateTimeoutWithExecutorServiceTest.aggregateThreadsCount(this.context.getName()) >= 20 ? 1 : 0) != 0, (String)"There should be a thread for every aggregator when using defaults");
        for (i = 0; i < 20; ++i) {
            MockEndpoint result = this.getMockEndpoint("mock:result" + i);
            result.expectedBodiesReceived(new Object[]{"Message 4"});
        }
        for (i = 0; i < 20; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.template.sendBodyAndHeader("direct:start" + i, (Object)("Message " + j), "id", (Object)"1");
            }
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                for (int i = 0; i < 20; ++i) {
                    this.from("direct:start" + i).aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(100L).completionTimeoutCheckerInterval(10L).to("mock:result" + i);
                }
            }
        };
    }
}

