/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateTimeoutWithExecutorServiceTest
extends ContextTestSupport {
    public static final int NUM_AGGREGATORS = 20;

    @Test
    public void testThreadNotUsedForEveryAggregatorWithCustomExecutorService() throws Exception {
        int i;
        Assertions.assertTrue((AggregateTimeoutWithExecutorServiceTest.aggregateThreadsCount(this.context.getName()) < 20 ? 1 : 0) != 0, (String)"There should not be a thread for every aggregator when using a shared thread pool");
        for (i = 0; i < 20; ++i) {
            MockEndpoint result = this.getMockEndpoint("mock:result" + i);
            result.expectedBodiesReceived(new Object[]{"Message 4"});
        }
        for (i = 0; i < 20; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.template.sendBodyAndHeader("direct:start" + i, (Object)("Message " + j), "id", (Object)"1");
            }
        }
        this.assertMockEndpointsSatisfied();
    }

    public static int aggregateThreadsCount(String contextName) {
        int count = 0;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || !thread.getName().contains("AggregateTimeoutChecker") || !thread.getName().contains(contextName)) continue;
            ++count;
        }
        return count;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ScheduledExecutorService threadPool = AggregateTimeoutWithExecutorServiceTest.this.context.getExecutorServiceManager().newScheduledThreadPool((Object)this, "MyThreadPool", 8);
                for (int i = 0; i < 20; ++i) {
                    this.from("direct:start" + i).aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(1000L).timeoutCheckerExecutorService(threadPool).completionTimeoutCheckerInterval(100L).to("mock:result" + i);
                }
            }
        };
    }
}

