/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateTimeoutTest
extends ContextTestSupport {
    private final AtomicInteger invoked = new AtomicInteger();
    private volatile Exchange receivedExchange;
    private volatile int receivedIndex;
    private volatile int receivedTotal;
    private volatile long receivedTimeout;

    @Test
    public void testAggregateTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        mock.assertIsSatisfied(200L);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> Assertions.assertEquals((int)1, (int)this.invoked.get()));
        Assertions.assertNotNull((Object)this.receivedExchange);
        Assertions.assertEquals((Object)"AB", (Object)this.receivedExchange.getIn().getBody());
        Assertions.assertEquals((int)-1, (int)this.receivedIndex);
        Assertions.assertEquals((int)-1, (int)this.receivedTotal);
        Assertions.assertEquals((long)100L, (long)this.receivedTimeout);
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        mock.assertIsSatisfied(150L);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> Assertions.assertEquals((int)1, (int)this.invoked.get()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).discardOnCompletionTimeout().completionSize(3).completionTimeout(100L).completionTimeoutCheckerInterval(10L).to("mock:aggregated");
            }
        };
    }

    private class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public void timeout(Exchange oldExchange, int index, int total, long timeout) {
            AggregateTimeoutTest.this.invoked.incrementAndGet();
            AggregateTimeoutTest.this.receivedExchange = oldExchange;
            AggregateTimeoutTest.this.receivedIndex = index;
            AggregateTimeoutTest.this.receivedTotal = total;
            AggregateTimeoutTest.this.receivedTimeout = timeout;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
            return oldExchange;
        }
    }
}

