/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class AggregateTimeoutOnlyTest
extends ContextTestSupport {
    @Test
    public void testAggregateTimeoutOnly() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Message 9"});
        result.setResultMinimumWaitTime(90L);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBodyAndHeader("direct:start", (Object)("Message " + i), "id", (Object)"1");
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(100L).completionTimeoutCheckerInterval(10L).to("mock:result");
            }
        };
    }
}

