/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.Test;

public class AggregateThreadPoolProfileTest
extends ContextTestSupport {
    @Test
    public void testAggregateThreadPoolProfile() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"A+B+C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ThreadPoolProfile profile = new ThreadPoolProfile("myProfile");
                profile.setPoolSize(Integer.valueOf(2));
                profile.setMaxPoolSize(Integer.valueOf(8));
                profile.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
                AggregateThreadPoolProfileTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                ((AggregateDefinition)this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(3).executorService("myProfile").to("log:foo")).to("mock:aggregated");
            }
        };
    }
}

