/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Test;

public class AggregateStrategyRefTest
extends ContextTestSupport {
    @Test
    public void testAggregateExpressionSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"A+A", "B+B", "Z"});
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBodyAndProperty("direct:start", (Object)"Z", "CamelBatchSize", (Object)5);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AggregateStrategyRefTest.this.context.getRegistry().bind("myStrategy", (Object)new BodyInAggregatingStrategy());
                this.from("direct:start").aggregate((Expression)this.body()).aggregationStrategy("myStrategy").completionFromBatchConsumer().to("mock:result");
            }
        };
    }
}

