/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Test;

public class AggregateSimplePredicateEagerTest
extends ContextTestSupport {
    @Test
    public void testAggregateSimplePredicateEager() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"A+B+C+END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).eagerCheckCompletion().completionPredicate(this.body().isEqualTo((Object)"END")).to("mock:aggregated");
            }
        };
    }
}

