/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="Manual unit test")
public class AggregateSimpleExpressionIssueManualTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateSimpleExpressionIssueManualTest.class);
    private static final String DATA = "100,200,1,123456,2010-03-01T12:13:14,100,USD,Best Buy,5045,Santa Monica,CA,Type\n";
    private final MyBean myBean = new MyBean();
    private final AggStrategy aggStrategy = new AggStrategy();

    @Test
    public void testAggregateSimpleExpression() throws Exception {
        int files = 10;
        int rows = 100000;
        int batches = rows / 1000;
        int total = files + files * rows + files * batches;
        LOG.info("There are {} exchanges", (Object)total);
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(total).create();
        LOG.info("Writing 10 files with 100000 rows in each file");
        for (int i = 0; i < files; ++i) {
            try (BufferedWriter out = Files.newBufferedWriter(this.testFile("data" + i), new OpenOption[0]);){
                for (int j = 0; j < rows; ++j) {
                    out.write(DATA);
                }
                continue;
            }
        }
        StopWatch watch = new StopWatch();
        this.context.getRouteController().startRoute("foo");
        LOG.info("Waiting to process all the files");
        boolean matches = notify.matches(3L, TimeUnit.MINUTES);
        LOG.info("Should process all files {}", (Object)matches);
        LOG.info("Time taken {} ms", (Object)watch.taken());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((AggregateDefinition)((SplitDefinition)((RouteDefinition)this.from(AggregateSimpleExpressionIssueManualTest.this.fileUri()).routeId("foo").autoStartup(false).log("Picked up ${file:name}")).split().tokenize("\n")).streaming().aggregate((Expression)this.constant(true), (AggregationStrategy)AggregateSimpleExpressionIssueManualTest.this.aggStrategy).completionSize((Expression)this.simple("1000")).completionTimeout((Expression)this.simple("500")).bean((Object)AggregateSimpleExpressionIssueManualTest.this.myBean)).end().end();
            }
        };
    }

    public static final class MyBean {
        private final LongAdder cnt = new LongAdder();

        public void invoke(List<String> strList) {
            this.cnt.increment();
            LOG.info("Batch {}", (Object)this.cnt.intValue());
        }
    }

    public static final class AggStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            String str = (String)newExchange.getIn().getBody(String.class);
            if (oldExchange == null) {
                int batchSize = 1000;
                ArrayList<String> list = new ArrayList<String>(batchSize);
                list.add(str);
                newExchange.getIn().setBody(list);
                return newExchange;
            }
            List list = (List)oldExchange.getIn().getBody(List.class);
            list.add(str);
            return oldExchange;
        }
    }
}

