/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateShutdownThreadPoolTest
extends ContextTestSupport {
    private ExecutorService myPool;

    @Test
    public void testAggregateShutdownDefaultThreadPoolTest() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"A+B+C"});
        this.template.sendBodyAndHeader("direct:foo", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:foo", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:foo", (Object)"C", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
        this.context.getRouteController().stopRoute("foo");
        this.resetMocks();
        this.context.getRouteController().startRoute("foo");
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"D+E+F"});
        this.template.sendBodyAndHeader("direct:foo", (Object)"D", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:foo", (Object)"E", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:foo", (Object)"F", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
        this.context.stop();
    }

    @Test
    public void testAggregateShutdownCustomThreadPoolTest() throws Exception {
        Assertions.assertFalse((boolean)this.myPool.isShutdown());
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"A+B+C"});
        this.template.sendBodyAndHeader("direct:bar", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:bar", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:bar", (Object)"C", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)this.myPool.isShutdown());
        this.context.getRouteController().stopRoute("bar");
        Assertions.assertFalse((boolean)this.myPool.isShutdown());
        this.resetMocks();
        this.context.getRouteController().startRoute("bar");
        Assertions.assertFalse((boolean)this.myPool.isShutdown());
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"D+E+F"});
        this.template.sendBodyAndHeader("direct:bar", (Object)"D", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:bar", (Object)"E", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:bar", (Object)"F", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)this.myPool.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)this.myPool.isShutdown());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                AggregateShutdownThreadPoolTest.this.myPool = AggregateShutdownThreadPoolTest.this.context.getExecutorServiceManager().newDefaultThreadPool((Object)this, "myPool");
                this.from("direct:foo").routeId("foo").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(3).to("mock:aggregated");
                this.from("direct:bar").routeId("bar").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).executorService(AggregateShutdownThreadPoolTest.this.myPool).completionSize(3).to("mock:aggregated");
            }
        };
    }
}

