/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class AggregateShouldSkipFilteredExchangesTest
extends ContextTestSupport {
    @Test
    public void testAggregateWithFilter() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World,Bye World"});
        MockEndpoint filtered = this.getMockEndpoint("mock:filtered");
        filtered.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi there", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"How do you do?", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Predicate goodWord = this.body().contains((Object)"World");
                ((AggregateDefinition)((ExpressionNode)this.from("direct:start").filter(goodWord).to("mock:filtered")).aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).completionTimeout(1000L).to("mock:result")).end().end();
            }
        };
    }

    private static class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String newBody = (String)newExchange.getIn().getBody(String.class);
            Object body = (String)oldExchange.getIn().getBody(String.class);
            body = (String)body + "," + newBody;
            oldExchange.getIn().setBody(body);
            return oldExchange;
        }
    }
}

