/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateRepositoryReturnNullTest
extends ContextTestSupport {
    @Test
    public void testAggregateRepositoryReturnNull() {
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "id", (Object)123);
            Assertions.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            AggregateRepositoryReturnNullTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("AggregationStrategy"));
            Assertions.assertTrue((boolean)e.getCause().getMessage().contains("returned null which is not allowed"));
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyNullAggregationStrategy()).completionSize(3).to("mock:result");
            }
        };
    }

    private static class MyNullAggregationStrategy
    implements AggregationStrategy {
        private MyNullAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            return null;
        }
    }
}

