/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Test;

public class AggregateParallelProcessingTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAggregateParallelProcessing() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).eagerCheckCompletion().completionPredicate(this.body().isEqualTo((Object)"END")).parallelProcessing().to(new String[]{"log:result", "mock:result"});
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"A+Donkey+END", "B+Camel+END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Donkey", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Camel", "id", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAggregateNotParallelProcessing() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).eagerCheckCompletion().completionPredicate(this.body().isEqualTo((Object)"END")).to(new String[]{"log:result", "mock:result"});
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+Donkey+END", "B+Camel+END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Donkey", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Camel", "id", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)2);
        this.assertMockEndpointsSatisfied();
    }
}

