/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateNewExchangeAndConfirmTest
extends ContextTestSupport {
    private final MyRepo repo = new MyRepo();

    @Test
    public void testAggregateNewExchangeAndConfirm() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> this.repo.getId() != null);
        Assertions.assertEquals((Object)((Exchange)mock.getReceivedExchanges().get(0)).getExchangeId(), (Object)this.repo.getId());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyNewExchangeAggregationStrategy()).aggregationRepository((AggregationRepository)AggregateNewExchangeAndConfirmTest.this.repo).completionSize(3).to("mock:aggregated");
            }
        };
    }

    private class MyRepo
    extends MemoryAggregationRepository {
        private String id;

        private MyRepo() {
        }

        public void confirm(CamelContext camelContext, String exchangeId) {
            AggregateNewExchangeAndConfirmTest.this.log.info("Confirmed id: {}", (Object)exchangeId);
            this.id = exchangeId;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class MyNewExchangeAggregationStrategy
    implements AggregationStrategy {
        private MyNewExchangeAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            Object body = "";
            if (oldExchange != null) {
                body = (String)oldExchange.getIn().getBody(String.class);
            }
            body = (String)body + (String)newExchange.getIn().getBody(String.class);
            newExchange.getIn().setBody(body);
            return newExchange;
        }
    }
}

