/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on GitHub Actions")
public class AggregateLostGroupIssueTest
extends ContextTestSupport {
    private int messageIndex;
    private MemoryAggregationRepository aggregationRepository;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.messageIndex = 0;
        super.setUp();
        this.getAggregationRepository().start();
        this.context.getRouteController().startRoute("foo");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.context.getRouteController().stopRoute("foo");
        this.getAggregationRepository().stop();
        super.tearDown();
    }

    @Test
    public void testAggregateLostGroupIssue() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"0,1,2,3,4,5,6,7,8,9");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"10,11,12,13,14,15,16,17,18,19");
        this.assertMockEndpointsSatisfied();
    }

    protected synchronized MemoryAggregationRepository getAggregationRepository() {
        if (this.aggregationRepository == null) {
            this.aggregationRepository = new MemoryAggregationRepository();
        }
        return this.aggregationRepository;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("timer://foo?period=10&delay=0").id("foo")).startupOrder(2).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getMessage().setBody((Object)AggregateLostGroupIssueTest.this.messageIndex++);
                        exchange.getMessage().setHeader("aggregateGroup", (Object)"group1");
                    }
                })).to("direct:aggregator");
                ((AggregateDefinition)this.from("direct:aggregator").startupOrder(1).aggregate((Expression)this.header("aggregateGroup"), new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String oldBody = (String)oldExchange.getIn().getBody(String.class);
                        String newBody = (String)newExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(oldBody + "," + newBody));
                        return oldExchange;
                    }
                }).aggregationRepository((AggregationRepository)AggregateLostGroupIssueTest.this.getAggregationRepository()).completionSize(10).completionTimeout(500L).completionTimeoutCheckerInterval(100L).to("log:aggregated")).to("mock:result");
            }
        };
    }
}

