/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.GroupedExchangeAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateGroupedExchangeSizePredicateTest
extends ContextTestSupport {
    @Test
    public void testGroupedSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"100", "groupSize", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"150", "groupSize", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"130", "groupSize", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"200", "groupSize", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"190", "groupSize", (Object)2);
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)result.getExchanges().get(0);
        List grouped = (List)out.getIn().getBody(List.class);
        Assertions.assertEquals((int)3, (int)grouped.size());
        Assertions.assertEquals((Object)"100", (Object)((Exchange)grouped.get(0)).getIn().getBody(String.class));
        Assertions.assertEquals((Object)"150", (Object)((Exchange)grouped.get(1)).getIn().getBody(String.class));
        Assertions.assertEquals((Object)"130", (Object)((Exchange)grouped.get(2)).getIn().getBody(String.class));
        out = (Exchange)result.getExchanges().get(1);
        grouped = (List)out.getIn().getBody(List.class);
        Assertions.assertEquals((int)2, (int)grouped.size());
        Assertions.assertEquals((Object)"200", (Object)((Exchange)grouped.get(0)).getIn().getBody(String.class));
        Assertions.assertEquals((Object)"190", (Object)((Exchange)grouped.get(1)).getIn().getBody(String.class));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((AggregateDefinition)((AggregateDefinition)this.from("direct:start").aggregate((AggregationStrategy)new GroupedExchangeAggregationStrategy()).constant((Object)true)).eagerCheckCompletion().completionSize((Expression)this.header("groupSize")).to("mock:result")).end();
            }
        };
    }
}

