/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.GroupedExchangeAggregationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateGroupedExchangeMultipleCorrelationTest
extends ContextTestSupport {
    @Test
    public void testGrouped() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"100", "foo", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"130", "foo", (Object)"B");
        this.template.sendBodyAndHeader("direct:start", (Object)"150", "foo", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"200", "foo", (Object)"B");
        this.template.sendBodyAndHeader("direct:start", (Object)"180", "foo", (Object)"B");
        Thread.sleep(250L);
        this.template.sendBodyAndHeader("direct:start", (Object)"120", "foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)result.getExchanges().get(0);
        List grouped = (List)out.getIn().getBody(List.class);
        Assertions.assertEquals((int)3, (int)grouped.size());
        Assertions.assertEquals((Object)"130", (Object)((Exchange)grouped.get(0)).getIn().getBody(String.class));
        Assertions.assertEquals((Object)"200", (Object)((Exchange)grouped.get(1)).getIn().getBody(String.class));
        Assertions.assertEquals((Object)"180", (Object)((Exchange)grouped.get(2)).getIn().getBody(String.class));
        out = (Exchange)result.getExchanges().get(1);
        grouped = (List)out.getIn().getBody(List.class);
        Assertions.assertEquals((int)3, (int)grouped.size());
        Assertions.assertEquals((Object)"100", (Object)((Exchange)grouped.get(0)).getIn().getBody(String.class));
        Assertions.assertEquals((Object)"150", (Object)((Exchange)grouped.get(1)).getIn().getBody(String.class));
        Assertions.assertEquals((Object)"120", (Object)((Exchange)grouped.get(2)).getIn().getBody(String.class));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("foo"), (AggregationStrategy)new GroupedExchangeAggregationStrategy()).completionTimeout(1000L).to("mock:result");
            }
        };
    }
}

