/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregator.MyCompletionProcessor;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class AggregateForceCompletionOnStopTest
extends ContextTestSupport {
    @Test
    public void testForceCompletionTrue() {
        MyCompletionProcessor myCompletionProcessor = (MyCompletionProcessor)this.context.getRegistry().lookupByNameAndType("myCompletionProcessor", MyCompletionProcessor.class);
        myCompletionProcessor.reset();
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.context.getShutdownStrategy().setTimeout(5L);
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test4", "id", (Object)"2");
        Assertions.assertEquals((int)0, (int)myCompletionProcessor.getAggregationCount(), (String)"aggregation should not have completed yet");
        this.context.stop();
        Assertions.assertEquals((int)2, (int)myCompletionProcessor.getAggregationCount(), (String)"aggregation should have completed");
    }

    @Test
    public void testForceCompletionFalse() {
        MyCompletionProcessor myCompletionProcessor = (MyCompletionProcessor)this.context.getRegistry().lookupByNameAndType("myCompletionProcessor", MyCompletionProcessor.class);
        myCompletionProcessor.reset();
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.context.getShutdownStrategy().setTimeout(5L);
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test4", "id", (Object)"2");
        Assertions.assertEquals((int)0, (int)myCompletionProcessor.getAggregationCount(), (String)"aggregation should not have completed yet");
        this.context.stop();
        Assertions.assertEquals((int)0, (int)myCompletionProcessor.getAggregationCount(), (String)"aggregation should not have completed yet");
    }

    @Test
    public void testStopRouteForceCompletionTrue() throws Exception {
        MyCompletionProcessor myCompletionProcessor = (MyCompletionProcessor)this.context.getRegistry().lookupByNameAndType("myCompletionProcessor", MyCompletionProcessor.class);
        myCompletionProcessor.reset();
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.context.getShutdownStrategy().setTimeout(5L);
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test4", "id", (Object)"2");
        Assertions.assertEquals((int)0, (int)myCompletionProcessor.getAggregationCount(), (String)"aggregation should not have completed yet");
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((int)2, (int)myCompletionProcessor.getAggregationCount(), (String)"aggregation should have completed");
    }

    @Test
    public void testStopRouteForceCompletionFalse() throws Exception {
        MyCompletionProcessor myCompletionProcessor = (MyCompletionProcessor)this.context.getRegistry().lookupByNameAndType("myCompletionProcessor", MyCompletionProcessor.class);
        myCompletionProcessor.reset();
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.context.getShutdownStrategy().setTimeout(5L);
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test4", "id", (Object)"2");
        Assertions.assertEquals((int)0, (int)myCompletionProcessor.getAggregationCount(), (String)"aggregation should not have completed yet");
        this.context.getRouteController().stopRoute("bar");
        Assertions.assertEquals((int)0, (int)myCompletionProcessor.getAggregationCount(), (String)"aggregation should not have completed yet");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myCompletionProcessor", (Object)new MyCompletionProcessor());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:forceCompletionTrue").routeId("foo").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).forceCompletionOnStop().completionSize(10).delay(100L).process("myCompletionProcessor");
                this.from("direct:forceCompletionFalse").routeId("bar").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(10).delay(100L).process("myCompletionProcessor");
            }
        };
    }
}

