/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.HashMap;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class AggregateForceCompletionHeaderTest
extends ContextTestSupport {
    @Test
    public void testForceCompletionTrueExclusive() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(2);
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceivedInAnyOrder(new Object[]{"test1test3", "test2test4"});
        this.getMockEndpoint("mock:aggregated").expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"force");
        ((MockValueBuilder)this.getMockEndpoint("mock:aggregated").allMessages().header("CamelAggregationCompleteAllGroups")).isNull();
        ((MockValueBuilder)this.getMockEndpoint("mock:aggregated").allMessages().exchangeProperty("CamelAggregationCompleteAllGroups")).isNull();
        this.template.sendBodyAndProperty("direct:start", (Object)"test5", "CamelAggregationCompleteAllGroups", (Object)true);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testForceCompletionTrueInclusive() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(3);
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceivedInAnyOrder(new Object[]{"test1test3", "test2test4", "test5"});
        this.getMockEndpoint("mock:aggregated").expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"force");
        ((MockValueBuilder)this.getMockEndpoint("mock:aggregated").allMessages().header("CamelAggregationCompleteAllGroupsInclusive")).isNull();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("id", "3");
        headers.put("CamelAggregationCompleteAllGroupsInclusive", true);
        this.template.sendBodyAndHeaders("direct:start", (Object)"test5", headers);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).completionSize(10).to("mock:aggregated");
            }
        };
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body1 = (String)oldExchange.getIn().getBody(String.class);
            String body2 = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body1 + body2));
            return oldExchange;
        }
    }
}

