/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class AggregateForceCompletionHeaderInAggregationStrategyTest
extends ContextTestSupport {
    @Test
    public void testCompletePreviousOnNewGroup() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"AAA", "BB"});
        ((MockValueBuilder)this.getMockEndpoint("mock:aggregated").allMessages().header("CamelAggregationCompleteAllGroups")).isNull();
        ((MockValueBuilder)this.getMockEndpoint("mock:aggregated").allMessages().exchangeProperty("CamelAggregationCompleteAllGroups")).isNull();
        this.template.sendBody("direct:start", (Object)"A,A,A,B,B");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body()).to("log:input?showAll=true")).aggregate((Expression)this.simple("${body}"), (AggregationStrategy)new MyAggregationStrategy()).completionPredicate((Predicate)this.exchangeProperty("CamelSplitComplete")).to(new String[]{"log:aggregated", "mock:aggregated"});
            }
        };
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                newExchange.setProperty("CamelAggregationCompleteAllGroups", (Object)true);
                return newExchange;
            }
            String body1 = (String)oldExchange.getIn().getBody(String.class);
            String body2 = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body1 + body2));
            oldExchange.setProperty("CamelSplitComplete", newExchange.getProperty("CamelSplitComplete"));
            return oldExchange;
        }
    }
}

