/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Test;

public class AggregateEagerCheckCompletionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAggregateEagerCheckCompletion() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionPredicate(this.body().isEqualTo((Object)"END")).eagerCheckCompletion().to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+B+END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAggregateNotEagerCheckCompletion() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id")).aggregationStrategy((AggregationStrategy)new BodyInAggregatingStrategy()).completionPredicate(this.body().isEqualTo((Object)"A+B+END")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+B+END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }
}

