/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.junit.jupiter.api.Test;

public class AggregateDslTest
extends ContextTestSupport {
    @Test
    public void testAggregate() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"0,3", "1,4", "2,5"});
        this.getMockEndpoint("mock:aggregated-supplier").expectedBodiesReceived(new Object[]{"0,3,6", "1,4,7", "2,5,8"});
        for (int i = 0; i < 9; ++i) {
            this.template.sendBodyAndHeader("direct:start", (Object)i, "type", (Object)(i % 3));
            this.template.sendBodyAndHeader("direct:start-supplier", (Object)i, "type", (Object)(i % 3));
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((AggregateDefinition)((AggregateDefinition)((AggregateDefinition)this.from("direct:start").aggregate().message(m -> m.getHeader("type"))).aggregationStrategy().body(String.class, AggregateDslTest::joinString)).completion().body(String.class, s -> s.split(",").length == 2)).to("mock:aggregated");
                ((AggregateDefinition)((AggregateDefinition)this.from("direct:start-supplier").aggregate().header("type")).aggregationStrategy(AggregateDslTest::joinStringStrategy).completion().body(String.class, s -> s.split(",").length == 3)).to("mock:aggregated-supplier");
            }
        };
    }

    private static String joinString(String o, String n) {
        return Stream.of(o, n).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    private static Exchange joinStringStrategy(Exchange oldExchange, Exchange newExchange) {
        newExchange.getIn().setBody((Object)AggregateDslTest.joinString(oldExchange != null ? (String)oldExchange.getIn().getBody(String.class) : null, (String)newExchange.getIn().getBody(String.class)));
        return newExchange;
    }
}

