/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateDiscardOnTimeoutTest
extends ContextTestSupport {
    @Test
    public void testAggregateDiscardOnTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        Thread.sleep(250L);
        mock.assertIsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"C+D+E"});
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "id", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "id", (Object)456);
        Assertions.assertTrue((boolean)mock.await(1000L, TimeUnit.MILLISECONDS));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(3).completionTimeout(200L).completionTimeoutCheckerInterval(10L).discardOnCompletionTimeout().to("mock:aggregated");
            }
        };
    }
}

