/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class AggregateDiscardOnFailureTest
extends ContextTestSupport {
    @Test
    public void testAggregateDiscardOnAggregationFailureFirst() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Kaboom", "id", (Object)123);
        mock.assertIsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"ABC", "DEF"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "id", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "id", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "id", (Object)456);
        mock.assertIsSatisfied();
    }

    @Test
    public void testAggregateDiscardOnAggregationFailureMiddle() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"Kaboom", "id", (Object)123);
        mock.assertIsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"ABC", "DEF"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "id", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "id", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "id", (Object)456);
        mock.assertIsSatisfied();
    }

    @Test
    public void testAggregateDiscardOnAggregationFailureLast() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"Kaboom", "id", (Object)123);
        mock.assertIsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"ABC", "DEF"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "id", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "id", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "id", (Object)456);
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).completionSize(3).completionTimeout(2000L).discardOnAggregationFailure().to("mock:aggregated");
            }
        };
    }

    private static class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if ("Kaboom".equals(newExchange.getMessage().getBody())) {
                throw new IllegalArgumentException("Forced");
            }
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getMessage().getBody(String.class) + (String)newExchange.getMessage().getBody(String.class);
            oldExchange.getMessage().setBody((Object)body);
            return oldExchange;
        }
    }
}

