/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.DefaultAggregateController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class AggregateControllerTest
extends ContextTestSupport {
    private AggregateController controller;

    public AggregateController getAggregateController() {
        if (this.controller == null) {
            this.controller = new DefaultAggregateController();
        }
        return this.controller;
    }

    @Test
    public void testForceCompletionOfAll() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(2);
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceivedInAnyOrder(new Object[]{"test1test3", "test2test4"});
        this.getMockEndpoint("mock:aggregated").expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"force");
        int groups = this.getAggregateController().forceCompletionOfAllGroups();
        Assertions.assertEquals((int)2, (int)groups);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testForceCompletionOfGroup() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(1);
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceivedInAnyOrder(new Object[]{"test1test3"});
        this.getMockEndpoint("mock:aggregated").expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"force");
        int groups = this.getAggregateController().forceCompletionOfGroup("1");
        Assertions.assertEquals((int)1, (int)groups);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testForceDiscardingOfGroup() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(1);
        this.getMockEndpoint("mock:aggregated").expectedHeaderReceived("id", (Object)"1");
        ((MockValueBuilder)this.getMockEndpoint("mock:aggregated").message(0).body()).startsWith((Object)"test6");
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test5", "id", (Object)"1");
        int groups = this.getAggregateController().forceDiscardingOfGroup("1");
        Assertions.assertEquals((int)1, (int)groups);
        this.template.sendBodyAndHeader("direct:start", (Object)"test6", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test7", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test8", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test9", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test10", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test11", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test12", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test13", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test14", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test15", "id", (Object)"1");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testForceDiscardingOfAll() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(1);
        this.getMockEndpoint("mock:aggregated").expectedHeaderReceived("id", (Object)"1");
        ((MockValueBuilder)this.getMockEndpoint("mock:aggregated").message(0).body()).startsWith((Object)"test6");
        this.template.sendBodyAndHeader("direct:start", (Object)"test0", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test5", "id", (Object)"1");
        int groups = this.getAggregateController().forceDiscardingOfAllGroups();
        Assertions.assertEquals((int)2, (int)groups);
        this.template.sendBodyAndHeader("direct:start", (Object)"test6", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test7", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test8", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test9", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test10", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test11", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test12", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test13", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test14", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test15", "id", (Object)"1");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).aggregateController(AggregateControllerTest.this.getAggregateController()).completionSize(10).to(new String[]{"log:aggregated", "mock:aggregated"});
            }
        };
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body1 = (String)oldExchange.getIn().getBody(String.class);
            String body2 = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body1 + body2));
            return oldExchange;
        }
    }
}

