/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="Creates lots of threads")
public class AggregateConcurrentPerCorrelationKeyTest
extends ContextTestSupport {
    private final String uri = "direct:start";

    @Test
    public void testAggregateConcurrentPerCorrelationKey() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(20);
        ArrayList<1> tasks = new ArrayList<1>();
        int size = 200;
        int i = 0;
        while (i < size) {
            final int id = i % 5;
            final int count = i++;
            tasks.add(new Callable<Object>(){

                @Override
                public Object call() {
                    AggregateConcurrentPerCorrelationKeyTest.this.template.sendBodyAndHeader("direct:start", (Object)Integer.toString(count), "id", (Object)id);
                    return null;
                }
            });
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(5);
        service.invokeAll(tasks);
        this.assertMockEndpointsSatisfied();
        service.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(40).to("mock:result");
            }
        };
    }
}

