/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Test;

public class AggregateCompletionSizeAndBatchConsumerTest
extends ContextTestSupport {
    @Test
    public void testAggregateExpressionSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"A+A+A", "A", "B+B", "Z"});
        ((MockValueBuilder)result.message(0).exchangeProperty("CamelAggregatedCompletedBy")).isEqualTo((Object)"size");
        ((MockValueBuilder)result.message(1).exchangeProperty("CamelAggregatedCompletedBy")).isEqualTo((Object)"consumer");
        ((MockValueBuilder)result.message(2).exchangeProperty("CamelAggregatedCompletedBy")).isEqualTo((Object)"consumer");
        ((MockValueBuilder)result.message(3).exchangeProperty("CamelAggregatedCompletedBy")).isEqualTo((Object)"consumer");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBodyAndProperty("direct:start", (Object)"Z", "CamelBatchSize", (Object)7);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.body(), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(3).completionFromBatchConsumer().to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

