/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Test;

public class AggregateCompletionPredicateTest
extends ContextTestSupport {
    @Test
    public void testCompletionPredicateBeforeTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"A+B+C+END"});
        mock.setResultWaitTime(10000L);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMultipleCompletionPredicateBeforeTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"A+B+C+END", "D+E+END", "F+G+H+I+END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"G", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"H", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"I", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCompletionPredicateBeforeTimeoutTwoGroups() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"A+B+C+END", "1+2+3+4+END"});
        mock.setResultWaitTime(10000L);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"1", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"2", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"3", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"4", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMultipleCompletionPredicateBeforeTimeoutTwoGroups() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"A+B+C+END", "1+2+3+4+END", "5+6+END", "D+E+END", "7+8+END", "F+G+H+I+END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"1", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"2", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"3", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"4", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"5", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"6", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"7", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"G", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"H", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"8", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"I", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionPredicate(this.body().contains((Object)"END")).completionTimeout(20000L).to("mock:aggregated");
            }
        };
    }
}

