/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.time.Duration;
import java.util.Set;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.spi.AggregationRepository;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateCompletionOnlyOneTest
extends ContextTestSupport {
    private final MyRepo repo = new MyRepo();

    @Test
    public void testOnlyOne() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"A", "B", "C", "END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> {
            Assertions.assertEquals((int)4, (int)this.repo.getGet());
            Assertions.assertEquals((int)0, (int)this.repo.getAdd());
            Assertions.assertEquals((int)0, (int)this.repo.getRemove());
            Assertions.assertEquals((int)4, (int)this.repo.getConfirm());
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)AggregateCompletionOnlyOneTest.this.repo).completionSize(1).to("mock:aggregated");
            }
        };
    }

    private static class MyRepo
    implements AggregationRepository {
        private int add;
        private int get;
        private int remove;
        private int confirm;

        private MyRepo() {
        }

        public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
            ++this.add;
            return null;
        }

        public Exchange get(CamelContext camelContext, String key) {
            ++this.get;
            return null;
        }

        public void remove(CamelContext camelContext, String key, Exchange exchange) {
            ++this.remove;
        }

        public void confirm(CamelContext camelContext, String exchangeId) {
            ++this.confirm;
        }

        public Set<String> getKeys() {
            return null;
        }

        public int getAdd() {
            return this.add;
        }

        public int getGet() {
            return this.get;
        }

        public int getRemove() {
            return this.remove;
        }

        public int getConfirm() {
            return this.confirm;
        }
    }
}

