/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateCompletionOnNewCorrelationGroupWithCanPreCompleteTest
extends ContextTestSupport {
    @Test
    public void testCompletionOnNewCorrelationGroup() throws Exception {
        int numItems = 2000;
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(numItems + 1);
        ArrayList<Object> input = new ArrayList<Object>();
        for (int j = 0; j < numItems; ++j) {
            for (int i = 0; i < 2; ++i) {
                input.add("A" + j);
            }
        }
        input.add("C");
        input.add("C");
        input.add("C");
        input.add("end");
        this.template.sendBody("direct:start", input);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((SplitDefinition)this.from("direct:start").split().body()).streaming().parallelProcessing(false).process(exchange -> {
                    if ("end".equals(exchange.getIn().getBody())) {
                        exchange.getIn().setHeader("id", (Object)"C".hashCode());
                    } else {
                        exchange.getIn().setHeader("id", (Object)exchange.getIn().getBody().hashCode());
                    }
                })).aggregate((Expression)this.header("id"), (AggregationStrategy)new CanPreCompleteAggregationStrategy()).completionOnNewCorrelationGroup().to(new String[]{"log:aggregated", "mock:aggregated"});
            }
        };
    }

    public static class CanPreCompleteAggregationStrategy
    implements AggregationStrategy {
        private static final Logger LOG = LoggerFactory.getLogger(CanPreCompleteAggregationStrategy.class);

        public boolean canPreComplete() {
            return true;
        }

        public boolean preComplete(Exchange oldExchange, Exchange newExchange) {
            String body2;
            String body1;
            String newExchangeId;
            String oldExchangeId;
            boolean preComplete = false;
            if (oldExchange == null) {
                oldExchangeId = null;
                newExchangeId = newExchange.getExchangeId();
                body1 = null;
                body2 = (String)newExchange.getIn().getBody(String.class);
            } else {
                body1 = (String)oldExchange.getIn().getBody(String.class);
                body2 = (String)newExchange.getIn().getBody(String.class);
                oldExchangeId = oldExchange.getExchangeId();
                newExchangeId = newExchange.getExchangeId();
            }
            LOG.debug("preComplete body1[{}] body2[{}] [{}] [{}]", new Object[]{body1, body2, oldExchangeId, newExchangeId});
            if (newExchange.getIn().getBody().equals("end")) {
                preComplete = true;
            }
            LOG.debug("preComplete[{}]", (Object)preComplete);
            return preComplete;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            LOG.debug("aggregate");
            if (oldExchange == null) {
                LOG.debug("aggregate oldExchange[{}] newExchangeId[{}]", (Object)oldExchange, (Object)newExchange.getExchangeId());
                return newExchange;
            }
            String body1 = (String)oldExchange.getIn().getBody(String.class);
            String body2 = (String)newExchange.getIn().getBody(String.class);
            LOG.debug("aggregate body1[{}] body2[{}] [{}] [{}]", new Object[]{body1, body2, oldExchange.getExchangeId(), newExchange.getExchangeId()});
            oldExchange.getIn().setBody((Object)(body1 + body2));
            LOG.debug("aggregate [{}] [{}] [{}]", new Object[]{oldExchange.getIn().getBody(), oldExchange.getExchangeId(), newExchange.getExchangeId()});
            return oldExchange;
        }

        public void onCompletion(Exchange exchange) {
            LOG.debug("onCompletion[{}]", (Object)exchange.getExchangeId());
        }
    }
}

